/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class IdPAttributePrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "IDPATTR";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_ENTRY_FIELD = "VALS";
    @Nonnull
    @NotEmpty
    private static final String EMPTY_VALUE_FIELD = "EMPTY";
    @Nonnull
    @NotEmpty
    private static final String STRING_VALUE_FIELD = "STR";
    @Nonnull
    @NotEmpty
    private static final String SCOPED_VALUE_FIELD = "SCO";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"IDPATTR\":.*,\"VALS\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdPAttributePrincipalSerializer.class);
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory;

    public IdPAttributePrincipalSerializer() {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        assert (factory != null);
        this.objectBuilderFactory = factory;
    }

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof IdPAttributePrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        StringWriter sink = new StringWriter(128);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(PRINCIPAL_NAME_FIELD, principal.getName());
            IdPAttribute attribute = ((IdPAttributePrincipal)principal).getAttribute();
            JsonArrayBuilder arrayBuilder = this.getJsonArrayBuilder();
            for (IdPAttributeValue value : attribute.getValues()) {
                assert (value != null);
                JsonObject obj = this.serializeValue(value);
                if (obj != null) {
                    arrayBuilder.add((JsonValue)obj);
                    continue;
                }
                this.log.warn("Skipping unsupported attribute value type ({})", value.getClass());
            }
            gen.write(PRINCIPAL_ENTRY_FIELD, (JsonValue)arrayBuilder.build());
            gen.writeEnd();
        }
        String result = sink.toString();
        assert (result != null);
        return result;
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IdPAttributePrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try {
            String nativeString;
            JsonArray vals;
            block15: {
                JsonReader reader = this.getJsonReader(new StringReader(value));
                JsonStructure st = reader.read();
                if (!(st instanceof JsonObject)) {
                    throw new IOException("Found invalid data structure while parsing IdPAttributePrincipal");
                }
                JsonObject obj = (JsonObject)st;
                JsonString str = obj.getJsonString(PRINCIPAL_NAME_FIELD);
                vals = obj.getJsonArray(PRINCIPAL_ENTRY_FIELD);
                nativeString = str != null ? str.getString() : null;
                if (nativeString == null || Strings.isNullOrEmpty((String)nativeString) || vals == null) {
                    this.log.warn("Skipping IdPAttributePrincipal missing attribute name or values");
                    IdPAttributePrincipal idPAttributePrincipal = null;
                    return idPAttributePrincipal;
                }
                break block15;
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            IdPAttribute attribute = new IdPAttribute(nativeString);
            ArrayList<IdPAttributeValue> values = new ArrayList<IdPAttributeValue>();
            Iterator iterator = vals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    attribute.setValues(values);
                    iterator = new IdPAttributePrincipal(attribute);
                    return iterator;
                }
                JsonValue entry = (JsonValue)iterator.next();
                if (entry instanceof JsonObject) {
                    IdPAttributeValue attrValue = this.deserializeValue((JsonObject)entry);
                    if (attrValue != null) {
                        values.add(attrValue);
                        continue;
                    }
                    this.log.warn("Skipping unsupported attribute value serialization");
                    continue;
                }
                this.log.warn("Skipping non-object attribute value array entry");
            }
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing IdPAttributePrincipal", e);
        }
    }

    @Nullable
    protected JsonObject serializeValue(@Nonnull IdPAttributeValue value) {
        JsonObjectBuilder builder = this.getJsonObjectBuilder();
        if (value instanceof EmptyAttributeValue) {
            EmptyAttributeValue eVal = (EmptyAttributeValue)value;
            if (eVal.getValue().equals((Object)EmptyAttributeValue.EmptyType.NULL_VALUE)) {
                builder.add(EMPTY_VALUE_FIELD, 0);
            } else {
                builder.add(EMPTY_VALUE_FIELD, 1);
            }
            return builder.build();
        }
        if (value instanceof ScopedStringAttributeValue) {
            JsonArrayBuilder arrayBuilder = this.getJsonArrayBuilder();
            arrayBuilder.add(((ScopedStringAttributeValue)value).getValue());
            arrayBuilder.add(((ScopedStringAttributeValue)value).getScope());
            builder.add(SCOPED_VALUE_FIELD, arrayBuilder);
            return builder.build();
        }
        if (value instanceof StringAttributeValue) {
            builder.add(STRING_VALUE_FIELD, ((StringAttributeValue)value).getValue());
            return builder.build();
        }
        return null;
    }

    @Nullable
    protected IdPAttributeValue deserializeValue(@Nonnull JsonObject object) {
        JsonValue value;
        if (object.containsKey((Object)EMPTY_VALUE_FIELD)) {
            JsonValue value2 = (JsonValue)object.get((Object)EMPTY_VALUE_FIELD);
            if (value2 instanceof JsonNumber) {
                if (((JsonNumber)value2).intValueExact() == 0) {
                    return EmptyAttributeValue.NULL;
                }
                return EmptyAttributeValue.ZERO_LENGTH;
            }
        } else if (object.containsKey((Object)STRING_VALUE_FIELD)) {
            JsonValue value3 = (JsonValue)object.get((Object)STRING_VALUE_FIELD);
            if (value3 instanceof JsonString) {
                return new StringAttributeValue(((JsonString)value3).getString());
            }
        } else if (object.containsKey((Object)SCOPED_VALUE_FIELD) && (value = (JsonValue)object.get((Object)SCOPED_VALUE_FIELD)) instanceof JsonArray && ((JsonArray)value).size() == 2) {
            return new ScopedStringAttributeValue(((JsonString)((JsonArray)value).get(0)).getString(), ((JsonString)((JsonArray)value).get(1)).getString());
        }
        return null;
    }

    @Nonnull
    private synchronized JsonObjectBuilder getJsonObjectBuilder() {
        JsonObjectBuilder result = this.objectBuilderFactory.createObjectBuilder();
        assert (result != null);
        return result;
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        JsonArrayBuilder result = this.objectBuilderFactory.createArrayBuilder();
        assert (result != null);
        return result;
    }
}

