/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.EnumeratableAccountLockoutManager;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LockoutManagerContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.EnumeratableStorageService;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class StorageBackedAccountLockoutManager
extends AbstractIdentifiableInitializableComponent
implements EnumeratableAccountLockoutManager {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StorageBackedAccountLockoutManager.class);
    @NonnullAfterInit
    private StorageService storageService;
    @Nullable
    private Function<ProfileRequestContext, String> lockoutKeyStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> maxAttemptsLookupStrategy = FunctionSupport.constant((Object)5);
    @Nonnull
    private Function<ProfileRequestContext, Duration> counterIntervalLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));
    @NonnullAfterInit
    private Function<ProfileRequestContext, Duration> lockoutDurationLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));
    private boolean extendLockoutDuration;

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
        StorageCapabilities caps = this.storageService.getCapabilities();
        Constraint.isTrue((boolean)caps.isServerSide(), (String)"StorageService cannot be client-side");
        if (!caps.isClustered()) {
            this.log.info("Use of non-clustered storage service will result in per-node lockout behavior");
        }
    }

    public void setLockoutKeyStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.lockoutKeyStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lockout key strategy cannot be null");
    }

    public void setMaxAttempts(@Positive int attempts) {
        this.checkSetterPreconditions();
        this.maxAttemptsLookupStrategy = FunctionSupport.constant((Object)Constraint.isGreaterThan((int)0, (int)attempts, (String)"Attempts must be greater than zero"));
    }

    public void setMaxAttemptsLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.checkSetterPreconditions();
        this.maxAttemptsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Max attempts lookup strategy cannot be null");
    }

    public void setCounterInterval(@Nonnull Duration window) {
        this.checkSetterPreconditions();
        this.counterIntervalLookupStrategy = FunctionSupport.constant((Object)((Duration)Constraint.isNotNull((Object)window, (String)"Counter interval cannot be null")));
    }

    public void setCounterIntervalLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.counterIntervalLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Counter interval lookup strategy cannot be null");
    }

    public void setLockoutDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        this.lockoutDurationLookupStrategy = FunctionSupport.constant((Object)((Duration)Constraint.isNotNull((Object)duration, (String)"Lockout duration cannot be null")));
    }

    public void setLockoutDurationLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.lockoutDurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lockout duration lookup strategy cannot be null");
    }

    public void setExtendLockoutDuration(boolean flag) {
        this.checkSetterPreconditions();
        this.extendLockoutDuration = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.lockoutKeyStrategy == null) {
            throw new ComponentInitializationException("Lockout key strategy cannot be null");
        }
    }

    @Nonnull
    private Function<ProfileRequestContext, String> getLockoutKeyStrategy() {
        this.checkComponentActive();
        assert (this.lockoutKeyStrategy != null);
        return this.lockoutKeyStrategy;
    }

    public boolean check(@Nonnull ProfileRequestContext profileRequestContext) {
        boolean managerOp;
        String key;
        LockoutManagerContext managerCtx = (LockoutManagerContext)profileRequestContext.getSubcontext(LockoutManagerContext.class);
        if (managerCtx != null) {
            key = managerCtx.getKey();
            managerOp = true;
        } else {
            key = this.getLockoutKeyStrategy().apply(profileRequestContext);
            managerOp = false;
        }
        if (key == null) {
            this.log.warn("No lockout key returned for request");
            return false;
        }
        long lockoutDuration = this.lockoutDurationLookupStrategy.apply(profileRequestContext).toMillis();
        long counterInterval = this.counterIntervalLookupStrategy.apply(profileRequestContext).toMillis();
        int maxAttempts = this.maxAttemptsLookupStrategy.apply(profileRequestContext);
        return this.doCheck(profileRequestContext, key, maxAttempts, lockoutDuration, counterInterval, this.extendLockoutDuration && !managerOp);
    }

    public boolean increment(@Nonnull ProfileRequestContext profileRequestContext) {
        LockoutManagerContext managerCtx = (LockoutManagerContext)profileRequestContext.getSubcontext(LockoutManagerContext.class);
        String key = managerCtx != null ? managerCtx.getKey() : this.getLockoutKeyStrategy().apply(profileRequestContext);
        if (key == null) {
            this.log.warn("No lockout key returned for request");
            return false;
        }
        long lockoutDuration = this.lockoutDurationLookupStrategy.apply(profileRequestContext).toMillis();
        long counterInterval = this.counterIntervalLookupStrategy.apply(profileRequestContext).toMillis();
        return this.doIncrement(profileRequestContext, key, 10, lockoutDuration, counterInterval);
    }

    public boolean clear(@Nonnull ProfileRequestContext profileRequestContext) {
        LockoutManagerContext managerCtx = (LockoutManagerContext)profileRequestContext.getSubcontext(LockoutManagerContext.class);
        String key = managerCtx != null ? managerCtx.getKey() : this.getLockoutKeyStrategy().apply(profileRequestContext);
        try {
            if (key != null) {
                this.log.debug("Clearing lockout state for '{}'", (Object)key);
                this.storageService.delete(this.ensureId(), key);
                return true;
            }
            this.log.warn("No lockout key returned for request");
        }
        catch (IOException e) {
            this.log.error("Error deleting lockout entry", (Throwable)e);
        }
        return false;
    }

    @Nullable
    public Iterable<String> enumerate(@Nonnull ProfileRequestContext profileRequestContext) {
        LockoutManagerContext managerCtx = (LockoutManagerContext)profileRequestContext.getSubcontext(LockoutManagerContext.class);
        String partialKey = managerCtx != null ? managerCtx.getKey() : null;
        if (partialKey == null) {
            this.log.warn("No lockout key provided for request");
            return null;
        }
        StorageService storageService = this.storageService;
        if (storageService instanceof EnumeratableStorageService) {
            Iterable keys;
            EnumeratableStorageService ess = (EnumeratableStorageService)storageService;
            try {
                keys = ess.getContextKeys(this.ensureId(), partialKey);
            }
            catch (IOException e) {
                this.log.error("Error enumerating lockout storage context", (Throwable)e);
                return null;
            }
            long lockoutDuration = this.lockoutDurationLookupStrategy.apply(profileRequestContext).toMillis();
            long counterInterval = this.counterIntervalLookupStrategy.apply(profileRequestContext).toMillis();
            int maxAttempts = this.maxAttemptsLookupStrategy.apply(profileRequestContext);
            ArrayList<String> results = new ArrayList<String>();
            for (String key : keys) {
                if (!key.startsWith(partialKey) || !this.doCheck(profileRequestContext, key, maxAttempts, lockoutDuration, counterInterval, false)) continue;
                results.add(key);
            }
            return results;
        }
        throw new UnsupportedOperationException("Underlying storage service does not support enumeration of keys");
    }

    protected boolean doCheck(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull String key, int maxAttempts, long lockoutDuration, long counterInterval, boolean increment) {
        StorageRecord sr = null;
        try {
            sr = this.storageService.read(this.ensureId(), key);
        }
        catch (IOException e) {
            sr = null;
            this.log.error("Error reading back account lockout state for '{}'", (Object)key, (Object)e);
        }
        if (sr == null) {
            this.log.debug("No lockout record available for '{}'", (Object)key);
            return false;
        }
        try {
            int counter = Integer.parseInt(sr.getValue());
            if (counter >= maxAttempts) {
                Long exp = (Long)Constraint.isNotNull((Object)sr.getExpiration(), (String)"Stored expiration canot be null");
                long lastAttempt = exp - Math.max(lockoutDuration, counterInterval);
                long timeDifference = System.currentTimeMillis() - lastAttempt;
                if (timeDifference <= lockoutDuration) {
                    this.log.info("Lockout threshold reached for '{}', invalid count is {}", (Object)key, (Object)counter);
                    if (increment) {
                        this.doIncrement(profileRequestContext, key, 10, lockoutDuration, counterInterval);
                    }
                    return true;
                }
                this.log.debug("Lockout for '{}' has elapsed", (Object)key);
            } else {
                this.log.debug("Invalid attempts counter for '{}' has only reached {}", (Object)key, (Object)counter);
            }
        }
        catch (NumberFormatException e) {
            this.log.error("Error converting lockout data for '{}' into integer", (Object)key, (Object)e);
        }
        return false;
    }

    protected boolean doIncrement(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String key, int retries, long lockoutDuration, long counterInterval) {
        long now;
        if (retries <= 0) {
            this.log.error("Account lockout increment attempts for '{}' exceeded retry limit", (Object)key);
            return false;
        }
        this.log.debug("Reading account lockout data for '{}'", (Object)key);
        int counter = 0;
        StorageRecord sr = null;
        try {
            sr = this.storageService.read(this.ensureId(), key);
            if (sr != null) {
                counter = Integer.parseInt(sr.getValue());
            }
        }
        catch (IOException e) {
            sr = null;
            counter = 0;
            this.log.error("Error reading back account lockout state for '{}'", (Object)key, (Object)e);
        }
        catch (NumberFormatException e) {
            sr = null;
            counter = 0;
            this.log.error("Error converting lockout data for '{}' into integer", (Object)key, (Object)e);
        }
        long lastAccess = now = System.currentTimeMillis();
        if (sr != null) {
            Long exp = (Long)Constraint.isNotNull((Object)sr.getExpiration(), (String)"Stored expiration canot be null");
            lastAccess = exp - Math.max(lockoutDuration, counterInterval);
        }
        if (now - lastAccess > counterInterval) {
            counter = 0;
        }
        long expiration = System.currentTimeMillis() + Math.max(lockoutDuration, counterInterval);
        this.log.debug("Invalid login count for '{}' will be {}, expiring at {}", new Object[]{key, ++counter, Instant.ofEpochMilli(expiration)});
        if (sr == null) {
            try {
                if (this.storageService.create(this.ensureId(), key, Integer.toString(counter), Long.valueOf(expiration))) {
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to create account lockout record for '{}'", (Object)key, (Object)e);
            }
        } else {
            try {
                if (this.storageService.update(this.ensureId(), key, Integer.toString(counter), Long.valueOf(expiration))) {
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to update account lockout record for '{}'", (Object)key, (Object)e);
            }
        }
        return this.doIncrement(profileRequestContext, key, retries - 1, lockoutDuration, counterInterval);
    }

    public static class UsernameIPLockoutKeyStrategy
    implements Function<ProfileRequestContext, String> {
        @Nullable
        private NonnullSupplier<HttpServletRequest> httpRequestSupplier;

        public void setHttpServletRequestSupplier(@Nonnull NonnullSupplier<HttpServletRequest> requestSupplier) {
            this.httpRequestSupplier = (NonnullSupplier)Constraint.isNotNull(requestSupplier, (String)"HttpServletRequest cannot be null");
        }

        @Nullable
        private HttpServletRequest getHttpServletRequest() {
            if (this.httpRequestSupplier == null) {
                return null;
            }
            assert (this.httpRequestSupplier != null);
            return (HttpServletRequest)this.httpRequestSupplier.get();
        }

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext profileRequestContext) {
            if (profileRequestContext == null) {
                return null;
            }
            if (this.getHttpServletRequest() == null) {
                return null;
            }
            AuthenticationContext authenticationContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
            if (authenticationContext == null) {
                return null;
            }
            UsernamePasswordContext upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
            if (upContext == null) {
                return null;
            }
            String username = upContext.getUsername();
            HttpServletRequest request = this.getHttpServletRequest();
            assert (request != null);
            String ipAddr = HttpServletSupport.getRemoteAddr((ServletRequest)request);
            if (username == null || username.isEmpty() || ipAddr == null || ipAddr.isEmpty()) {
                return null;
            }
            return username.toLowerCase() + "!" + ipAddr;
        }
    }
}

