/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PreserveAuthenticationFlowState
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PreserveAuthenticationFlowState.class);
    @Nonnull
    private Collection<String> parameterNames = CollectionSupport.emptyList();

    PreserveAuthenticationFlowState() {
    }

    public void setParameterNames(@Nullable Collection<String> names) {
        this.checkSetterPreconditions();
        this.parameterNames = names == null ? CollectionSupport.emptyList() : new ArrayList<String>(StringSupport.normalizeStringCollection(names));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.debug("No HttpServletRequest available");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map state = authenticationContext.getAuthenticationStateMap();
        state.clear();
        HttpServletRequest request = this.ensureHttpServletRequest();
        Map params = request.getParameterMap();
        for (String name : this.parameterNames) {
            String[] values = (String[])params.get(name);
            if (values == null) continue;
            if (values.length == 0) {
                state.put(name, null);
                continue;
            }
            if (values.length == 1) {
                state.put(name, values[0]);
                continue;
            }
            state.put(name, Arrays.asList(values));
        }
    }
}

