/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.config.IdentifiedComponentManager;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateSubjectCanonicalizationContext
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSubjectCanonicalizationContext.class);
    @Nonnull
    private Map<String, SubjectCanonicalizationFlowDescriptor> availableFlows = new LinkedHashMap<String, SubjectCanonicalizationFlowDescriptor>();
    @Nonnull
    private Collection<String> usableFlows = CollectionSupport.emptyList();

    PopulateSubjectCanonicalizationContext() {
    }

    public void setAvailableFlows(@Nonnull Collection<SubjectCanonicalizationFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        ((Collection)Constraint.isNotNull(flows, (String)"Flow collection cannot be null")).forEach(fd -> this.availableFlows.put(fd.ensureId(), (SubjectCanonicalizationFlowDescriptor)fd));
    }

    public void setAvailableFlows(@Nonnull IdentifiedComponentManager<SubjectCanonicalizationFlowDescriptor> manager) {
        this.checkSetterPreconditions();
        manager.getComponents().forEach(fd -> this.availableFlows.put(fd.ensureId(), (SubjectCanonicalizationFlowDescriptor)fd));
    }

    public void setUsableFlows(@Nullable List<String> usable) {
        this.checkSetterPreconditions();
        this.usableFlows = StringSupport.normalizeStringCollection(usable);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (this.usableFlows.isEmpty()) {
            this.log.debug("{} Installing {} c14n flows into SubjectCanonicalizationContext", (Object)this.getLogPrefix(), (Object)this.availableFlows.size());
            c14nContext.getPotentialFlows().putAll(this.availableFlows);
        } else {
            for (String id : this.usableFlows) {
                SubjectCanonicalizationFlowDescriptor fd = this.availableFlows.get(id);
                if (fd != null) {
                    c14nContext.getPotentialFlows().put(id, fd);
                    continue;
                }
                this.log.warn("{} Skipping installation of flow descriptor '{}', not available in configuration?", (Object)this.getLogPrefix(), (Object)id);
            }
            this.log.debug("{} Installed {} c14n flows into SubjectCanonicalizationContext", (Object)this.getLogPrefix(), (Object)c14nContext.getPotentialFlows().size());
        }
    }
}

