/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resource.Resource;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.KeyStoreCredentialReader;
import org.ldaptive.ssl.KeyStoreSSLContextInitializer;
import org.ldaptive.ssl.SSLContextInitializer;

public class KeystoreResourceCredentialConfig
implements CredentialConfig {
    @Nonnull
    private final KeyStoreCredentialReader keyStoreReader = new KeyStoreCredentialReader();
    @Nullable
    private Resource truststore;
    @Nullable
    private String truststorePassword;
    @Nullable
    private String truststoreType;
    @Nullable
    private String[] truststoreAliases;
    @Nullable
    private Resource keystore;
    @Nullable
    private String keystorePassword;
    @Nullable
    private String keystoreType;
    @Nullable
    private String[] keystoreAliases;

    public void setTruststore(@Nonnull @NotEmpty Resource resource) {
        this.truststore = (Resource)Constraint.isNotNull((Object)resource, (String)"Truststore resource cannot be null");
    }

    public void setTruststorePassword(@Nonnull @NotEmpty String password) {
        this.truststorePassword = (String)Constraint.isNotNull((Object)password, (String)"Truststore password cannot be null");
    }

    public void setTruststoreType(@Nonnull @NotEmpty String type) {
        this.truststoreType = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)type), (String)"Truststore type cannot be null or empty");
    }

    public void setTruststoreAliases(@Nonnull @NotEmpty String[] aliases) {
        this.truststoreAliases = (String[])Constraint.isNotNull((Object)aliases, (String)"Truststore aliases cannot be null or empty");
    }

    public void setKeystore(@Nonnull @NotEmpty Resource resource) {
        this.keystore = (Resource)Constraint.isNotNull((Object)resource, (String)"Keystore resource cannot be null");
    }

    public void setKeystorePassword(@Nonnull @NotEmpty String password) {
        this.keystorePassword = (String)Constraint.isNotNull((Object)password, (String)"Keystore password cannot be null");
    }

    public void setKeystoreType(@Nonnull @NotEmpty String type) {
        this.keystoreType = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)type), (String)"Keystore type cannot be null or empty");
    }

    public void setKeystoreAliases(@Nonnull @NotEmpty String[] aliases) {
        this.keystoreAliases = (String[])Constraint.isNotNull((Object)aliases, (String)"Keystore aliases cannot be null or empty");
    }

    public SSLContextInitializer createSSLContextInitializer() throws GeneralSecurityException {
        KeyStoreSSLContextInitializer sslInit = new KeyStoreSSLContextInitializer();
        try {
            if (this.truststore != null) {
                sslInit.setTrustKeystore(this.keyStoreReader.read(this.truststore.getInputStream(), new String[]{this.truststorePassword, this.truststoreType}));
                sslInit.setTrustAliases(this.truststoreAliases);
            }
            if (this.keystore != null) {
                sslInit.setAuthenticationKeystore(this.keyStoreReader.read(this.keystore.getInputStream(), new String[]{this.keystorePassword, this.keystoreType}));
                sslInit.setAuthenticationPassword(this.keystorePassword != null ? this.keystorePassword.toCharArray() : null);
                sslInit.setAuthenticationAliases(this.keystoreAliases);
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return sslInit;
    }
}

