/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttributeSupport;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.consent.context.ConsentManagementContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class ExternalAuthenticationImpl
extends ExternalAuthentication {
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    private final boolean extendedFlow;

    public ExternalAuthenticationImpl() {
        this(false);
    }

    public ExternalAuthenticationImpl(boolean extended) {
        this.extendedFlow = extended;
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected void doStart(@Nonnull HttpServletRequest request, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull ExternalAuthenticationContext externalAuthenticationContext) throws ExternalAuthenticationException {
        super.doStart(request, profileRequestContext, externalAuthenticationContext);
        AuthenticationContext authnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authnContext == null) {
            throw new ExternalAuthenticationException("No AuthenticationContext found");
        }
        if (authnContext.getAttemptedFlow() == null) {
            throw new ExternalAuthenticationException("No attempted authentication flow set");
        }
        request.setAttribute("extended", (Object)this.extendedFlow);
        request.setAttribute("isPassive", (Object)authnContext.isPassive());
        request.setAttribute("forceAuthn", (Object)authnContext.isForceAuthn());
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx != null) {
            request.setAttribute("relyingParty", (Object)rpCtx.getRelyingPartyId());
        }
    }

    protected void doFinish(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull ExternalAuthenticationContext extContext) throws ExternalAuthenticationException, IOException {
        Boolean flag;
        String s;
        Object ac;
        Duration dur;
        Object prin;
        if (extContext.getFlowExecutionUrl() == null) {
            throw new ExternalAuthenticationException("No flow execution URL found to return control");
        }
        Object object = request.getAttribute("subject");
        if (object instanceof Subject) {
            Subject sub = (Subject)object;
            extContext.setSubject(sub);
        } else {
            Object object2 = request.getAttribute("principal");
            if (object2 instanceof Principal) {
                prin = (Principal)object2;
                extContext.setPrincipal((Principal)prin);
            } else {
                Object object3 = request.getAttribute("principal_name");
                if (object3 instanceof String) {
                    String s2 = (String)object3;
                    extContext.setPrincipalName(s2);
                }
            }
        }
        prin = request.getAttribute("authnInstant");
        if (prin instanceof Instant) {
            Instant ts = (Instant)prin;
            extContext.setAuthnInstant(ts);
        }
        if ((prin = request.getAttribute("authnLifetime")) instanceof Duration) {
            dur = (Duration)prin;
            extContext.setAuthnLifetime(dur);
        }
        if ((prin = request.getAttribute("authnTimeout")) instanceof Duration) {
            dur = (Duration)prin;
            extContext.setAuthnTimeout(dur);
        }
        if ((prin = request.getAttribute("authnAuthorities")) instanceof Collection) {
            Collection c = (Collection)prin;
            extContext.getAuthenticatingAuthorities().addAll(c);
        }
        if ((prin = request.getAttribute("attributes")) instanceof Collection) {
            Collection attrs = (Collection)prin;
            ac = (AttributeContext)extContext.ensureSubcontext(AttributeContext.class);
            Map attributes = IdPAttributeSupport.toMapMergeDuplicates((Collection)attrs);
            ac.setUnfilteredIdPAttributes(attributes);
            ac.setIdPAttributes(attributes);
        }
        if ((ac = request.getAttribute("authnError")) instanceof String) {
            s = (String)ac;
            extContext.setAuthnError(s);
        }
        if ((ac = request.getAttribute("authnException")) instanceof Exception) {
            Exception e = (Exception)ac;
            extContext.setAuthnException(e);
        }
        if ((ac = request.getAttribute("authnEvent")) instanceof String) {
            s = (String)ac;
            extContext.setAuthnEvent(s);
        }
        if ((ac = request.getAttribute("doNotCache")) instanceof Boolean) {
            flag = (Boolean)ac;
            extContext.setDoNotCache(flag.booleanValue());
        }
        if ((ac = request.getAttribute("previousResult")) instanceof Boolean) {
            flag = (Boolean)ac;
            extContext.setPreviousResult(flag.booleanValue());
        }
        if ((ac = request.getAttribute("revokeConsent")) instanceof Boolean && (flag = (Boolean)ac).booleanValue()) {
            ConsentManagementContext consentCtx = (ConsentManagementContext)profileRequestContext.ensureSubcontext(ConsentManagementContext.class);
            consentCtx.setRevokeConsent(true);
        }
        response.sendRedirect(extContext.getFlowExecutionUrl());
    }
}

