/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizer;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AttributeSourcedSubjectCanonicalization
extends AbstractSubjectCanonicalizer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeSourcedSubjectCanonicalization.class);
    @NonnullAfterInit
    private ReloadableService<AttributeResolver> resolverService;
    @Nonnull
    private Predicate<ProfileRequestContext> resolutionCondition;
    private char delimiter = (char)64;
    private boolean resolveFromSubject;
    @Nonnull
    private Collection<String> attributesToResolve = CollectionSupport.emptyList();
    @Nonnull
    private List<String> attributeSourceIds = CollectionSupport.emptyList();
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;

    public AttributeSourcedSubjectCanonicalization() {
        this.resolutionCondition = PredicateSupport.alwaysTrue();
        this.issuerLookupStrategy = new IssuerLookupFunction();
        this.recipientLookupStrategy = new RelyingPartyIdLookupFunction();
        this.principalNameLookupStrategy = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
    }

    public void setAttributeResolver(@Nonnull ReloadableService<AttributeResolver> service) {
        this.checkSetterPreconditions();
        this.resolverService = (ReloadableService)Constraint.isNotNull(service, (String)"AttributeResolver service cannot be null");
    }

    public void setResolutionCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.resolutionCondition = (Predicate)Constraint.isNotNull(condition, (String)"Attribute resolution condition cannot be null");
    }

    public void setScopedDelimiter(char ch) {
        this.checkSetterPreconditions();
        this.delimiter = ch;
    }

    public void setResolveFromSubject(boolean flag) {
        this.checkSetterPreconditions();
        this.resolveFromSubject = flag;
    }

    public void setAttributesToResolve(@Nonnull Collection<String> ids) {
        this.checkSetterPreconditions();
        this.attributesToResolve = StringSupport.normalizeStringCollection(ids);
    }

    public void setAttributeSourceIds(@Nonnull List<String> ids) {
        this.checkSetterPreconditions();
        this.attributeSourceIds = new ArrayList<String>(StringSupport.normalizeStringCollection(ids));
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.recipientLookupStrategy = strategy;
    }

    public void setPrincipalNameLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.principalNameLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolverService == null) {
            throw new ComponentInitializationException("AttributeResolver service cannot be null");
        }
        if (this.attributeSourceIds.isEmpty()) {
            this.attributeSourceIds = CollectionSupport.copyToList(this.attributesToResolve);
        }
    }

    @Nullable
    protected String doApply(@Nonnull SubjectCanonicalizationContext c14nContext) {
        Map resolvedAttributes;
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)new RecursiveTypedParentContextLookup(ProfileRequestContext.class).apply((BaseContext)c14nContext);
        if (profileRequestContext == null) {
            this.log.error("{} Unable to locate ProfileRequestContext", (Object)this.getLogPrefix());
            return "InvalidSubjectCanonicalizationContext";
        }
        Map<String, IdPAttribute> subjectSourcedAttributes = this.resolveFromSubject ? this.extractSubjectSourcedAttributes(c14nContext) : CollectionSupport.emptyMap();
        if (this.resolutionCondition.test(profileRequestContext)) {
            resolvedAttributes = this.resolveAttributes(profileRequestContext, c14nContext);
        } else {
            this.log.debug("{} Skipping attribute resolution based on configured condition", (Object)this.getLogPrefix());
            resolvedAttributes = CollectionSupport.emptyMap();
        }
        for (String id : this.attributeSourceIds) {
            String result;
            IdPAttribute attr = subjectSourcedAttributes.get(id);
            if (attr != null) {
                result = this.findValue(attr);
                if (result == null) continue;
                c14nContext.setPrincipalName(result);
                return "proceed";
            }
            attr = (IdPAttribute)resolvedAttributes.get(id);
            if (attr == null || (result = this.findValue(attr)) == null) continue;
            c14nContext.setPrincipalName(result);
            return "proceed";
        }
        this.log.debug("{} Attribute sources {} did not produce a usable identifier", (Object)this.getLogPrefix(), this.attributeSourceIds);
        return null;
    }

    @Nonnull
    private Map<String, IdPAttribute> extractSubjectSourcedAttributes(@Nonnull SubjectCanonicalizationContext c14nContext) {
        Subject subject = (Subject)Constraint.isNotNull((Object)c14nContext.getSubject(), (String)"Expected a non-null Subject");
        Set<IdPAttributePrincipal> subjectSourced = subject.getPrincipals(IdPAttributePrincipal.class);
        if (subjectSourced != null && !subjectSourced.isEmpty()) {
            HashMap<String, IdPAttribute> subjectSourcedAttributes = new HashMap<String, IdPAttribute>(subjectSourced.size());
            subjectSourced.forEach(a -> subjectSourcedAttributes.put(a.getAttribute().getId(), a.getAttribute()));
            return subjectSourcedAttributes;
        }
        return CollectionSupport.emptyMap();
    }

    private Map<String, IdPAttribute> resolveAttributes(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        Map map;
        block13: {
            AttributeResolutionContext resolutionContext = (AttributeResolutionContext)c14nContext.ensureSubcontext(AttributeResolutionContext.class);
            resolutionContext.setProfileRequestContextLookupStrategy(FunctionSupport.constant((Object)profileRequestContext));
            SubjectCanonicalizationFlowDescriptor flow = c14nContext.getAttemptedFlow();
            if (flow != null) {
                resolutionContext.setResolutionLabel(flow.ensureId());
            }
            resolutionContext.setRequestedIdPAttributeNames(this.attributesToResolve);
            if (null != this.principalNameLookupStrategy) {
                resolutionContext.setPrincipal(this.principalNameLookupStrategy.apply(profileRequestContext));
            }
            if (this.recipientLookupStrategy != null) {
                resolutionContext.setAttributeRecipientID(this.recipientLookupStrategy.apply(profileRequestContext));
            }
            if (this.issuerLookupStrategy != null) {
                resolutionContext.setAttributeIssuerID(this.issuerLookupStrategy.apply(profileRequestContext));
            }
            ServiceableComponent component = this.resolverService.getServiceableComponent();
            try {
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                attributeResolver.resolveAttributes(resolutionContext);
                c14nContext.removeSubcontext((BaseContext)resolutionContext);
                map = resolutionContext.getResolvedIdPAttributes();
                if (component == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (component != null) {
                        try {
                            component.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResolutionException e) {
                    c14nContext.removeSubcontext((BaseContext)resolutionContext);
                    this.log.error("{} Error resolving attributes", (Object)this.getLogPrefix(), (Object)e);
                    return CollectionSupport.emptyMap();
                }
                catch (ServiceException e) {
                    c14nContext.removeSubcontext((BaseContext)resolutionContext);
                    this.log.error("{} Invalid AttributeResolver configuration", (Object)this.getLogPrefix(), (Object)e);
                    return CollectionSupport.emptyMap();
                }
            }
            component.close();
        }
        return map;
    }

    @Nullable
    private String findValue(@Nonnull IdPAttribute attribute) {
        for (IdPAttributeValue val : attribute.getValues()) {
            if (val instanceof ScopedStringAttributeValue) {
                ScopedStringAttributeValue scoped = (ScopedStringAttributeValue)val;
                String withScope = scoped.getValue() + this.delimiter + scoped.getScope();
                this.log.debug("{} Using attribute {} scoped value {} as input to transforms", new Object[]{this.getLogPrefix(), attribute.getId(), withScope});
                return this.applyTransforms(withScope);
            }
            if (val instanceof StringAttributeValue) {
                StringAttributeValue stringVal = (StringAttributeValue)val;
                if (stringVal.getValue() == null || stringVal.getValue().isEmpty()) {
                    this.log.debug("{} Ignoring null/empty string value", (Object)this.getLogPrefix());
                    continue;
                }
                this.log.debug("{} Using attribute {} string value {} as input to transforms", new Object[]{this.getLogPrefix(), attribute.getId(), stringVal.getValue()});
                return this.applyTransforms(stringVal.getValue());
            }
            this.log.warn("{} Unsupported attribute value type: {}", (Object)this.getLogPrefix(), (Object)val.getClass().getName());
        }
        return null;
    }
}

