/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.saml.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.filter.spring.policyrule.BasePolicyRuleParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class AbstractRegistrationAuthorityRuleParser
extends BasePolicyRuleParser {
    @Nonnull
    public static final String REGISTRARS_ATTR_NAME = "registrars";
    @Nonnull
    public static final String MATCH_IF_METADATA_SILENT_ATTR_NAME = "matchIfMetadataSilent";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractRegistrationAuthorityRuleParser.class);

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        Attr attr;
        if (element.hasAttributeNS(null, MATCH_IF_METADATA_SILENT_ATTR_NAME)) {
            String matchIfSilent = element.getAttributeNS(null, MATCH_IF_METADATA_SILENT_ATTR_NAME);
            this.log.debug("Registration Authority Filter: Match if Metadata silent = {}", (Object)matchIfSilent);
            builder.addPropertyValue(MATCH_IF_METADATA_SILENT_ATTR_NAME, (Object)SpringSupport.getStringValueAsBoolean((String)matchIfSilent));
        }
        if ((attr = element.getAttributeNodeNS(null, REGISTRARS_ATTR_NAME)) != null) {
            AbstractBeanDefinition registrars = SpringSupport.getAttributeValueAsList((Attr)attr);
            this.log.debug("Registration Authority Filter: registrars = {}", (Object)attr.getValue());
            builder.addPropertyValue(REGISTRARS_ATTR_NAME, (Object)registrars);
        }
    }
}

