/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.filter.AttributeRule;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.spring.BaseFilterParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeRuleParser
extends BaseFilterParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRule");
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRuleType");
    @Nonnull
    @NotEmpty
    public static final String PERMIT_ANY_ATTRIBUTE = "permitAny";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRuleParser.class);

    @Nullable
    protected Class<?> getBeanClass(@Nonnull Element arg) {
        return AttributeRule.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String id = this.resolveId(config, builder.getBeanDefinition(), parserContext);
        builder.addPropertyValue("id", (Object)id);
        String attributeId = StringSupport.trimOrNull((String)config.getAttributeNS(null, "attributeID"));
        builder.addPropertyValue("attributeId", (Object)attributeId);
        List permitValueRule = ElementSupport.getChildElements((Node)config, (QName)BaseFilterParser.PERMIT_VALUE_RULE);
        List denyValueRule = ElementSupport.getChildElements((Node)config, (QName)BaseFilterParser.DENY_VALUE_RULE);
        if (permitValueRule != null && !permitValueRule.isEmpty()) {
            if (permitValueRule.size() > 1) {
                this.log.debug("{} : More than one PermitValueRule, only the first will be used", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
            Element rule = (Element)permitValueRule.get(0);
            assert (rule != null);
            builder.addPropertyValue("matcher", (Object)SpringSupport.parseCustomElement((Element)rule, (ParserContext)parserContext, (BeanDefinitionBuilder)builder, (boolean)false));
            builder.addPropertyValue("isDenyRule", (Object)false);
        } else if (denyValueRule != null && !denyValueRule.isEmpty()) {
            if (denyValueRule.size() > 1) {
                this.log.debug("{} : More than one DenyValueRule, only the first will be used", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
            Element rule = (Element)denyValueRule.get(0);
            assert (rule != null);
            builder.addPropertyValue("matcher", (Object)SpringSupport.parseCustomElement((Element)rule, (ParserContext)parserContext, (BeanDefinitionBuilder)builder, (boolean)false));
            builder.addPropertyValue("isDenyRule", (Object)true);
        } else {
            Boolean permitAny;
            Attr permitAnyAttribute = config.getAttributeNodeNS(null, PERMIT_ANY_ATTRIBUTE);
            if (permitAnyAttribute != null && (permitAny = AttributeSupport.getAttributeValueAsBoolean((Attr)permitAnyAttribute)) != null && permitAny.booleanValue()) {
                builder.addPropertyValue("isDenyRule", (Object)false);
                builder.addPropertyValue("matcher", (Object)Matcher.MATCHES_ALL);
                return;
            }
            this.log.warn("{}: Attribute rule must have PermitValueRule or a DenyValueRule, or have attribute permitAny=\"true\"", (Object)parserContext.getReaderContext().getResource().getDescription());
        }
    }
}

